IF EXISTS(SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_EXTRATO_FORN_GERAL' )
    DROP FUNCTION [dbo].[UFD_CG_EXTRATO_FORN_GERAL];
GO

/****** Object:  UserDefinedFunction [dbo].[UFD_CG_EXTRATO_FORN_GERAL]    Script Date: 04/16/2012 15:30:13 ******/

SET ANSI_NULLS ON;
GO

SET QUOTED_IDENTIFIER ON;
GO

--SELECT * FROM UFD_CG_EXTRATO_FORN_GERAL (1,'2011-01-01','2011-11-22') ORDER BY CD_FORN,DT_LANCTO
CREATE FUNCTION [dbo].[UFD_CG_EXTRATO_FORN_GERAL] (@CD_EMP INT, @DT_INI DATETIME, @DT_FIM DATETIME)
RETURNS @RS_RETORNO TABLE
				(TP_LANC           INT,
				 CD_FND_VERBA      INT,
				 DT_LANCTO         datetime,
				 DT_VENCTO         datetime,
				 CD_FORN           INT,
				 NM_FANT           VARCHAR(255) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 VERBA             VARCHAR(200) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 HIST              VARCHAR(200) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 NEGOCIADO         MONEY,
				 CREDITO           MONEY,
				 DEBITO            MONEY,
				 SLD_USO           MONEY,
				 SLD_RECB          MONEY,
				 NR_DUP            VARCHAR(100) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 CD_FILIAL         INT,
				 ORDEM             INT,
				 CD_NEGOCIADOR     INT,
				 NM_NEGOCIADOR     VARCHAR(50) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 QTDE_DIAS_VENCIDO INT,
				 DS_FND_VERBA_TIPO VARCHAR(150) COLLATE SQL_Latin1_General_CP1_CI_AS,
				 PARC              TINYINT,
				 VLR_DP            MONEY
				)
WITH ENCRYPTION
AS
     BEGIN
         INSERT INTO @RS_RETORNO (TP_LANC, CD_FND_VERBA, DT_LANCTO
							 , DT_VENCTO, CD_FORN, NM_FANT, VERBA
							 , HIST, NEGOCIADO, CREDITO, DEBITO, SLD_USO, SLD_RECB
							 , ORDEM, CD_NEGOCIADOR, NM_NEGOCIADOR, QTDE_DIAS_VENCIDO, DS_FND_VERBA_TIPO
							 , PARC, VLR_DP, NR_DUP, CD_FILIAL)
                SELECT 1 TP_LANC
                     , V.CD_FND_VERBA
                     , R.DT_RECEB
				 , V.DT_VENCTO
                     , V.CD_FORN
                     , '' NM_FANT
                     , V.HIST_LANC VERBA
                     , R.HIST_LANC
                     , 0 AS NEGOCIADO
                     , R.VLR_RECB AS CREDITO
                     , 0 AS DEBITO
                     , (V.VLR_LANC - V.VLR_GLOSA) - ISNULL(
                                                          (
                                                              SELECT SLD_USO
                                                              FROM UFD_CG_RETORNA_SALDO_USO_FORN(@CD_EMP, V.CD_FND_VERBA, V.CD_FORN, R.DT_RECEB - 1)
                                                          ), 0) AS SLD_USO
                     , (V.VLR_LANC - V.VLR_GLOSA) - ISNULL(
                                                          (
                                                              SELECT SLD_RECB
                                                              FROM UFD_CG_RETORNA_SALDO_RECEB_FORN(@CD_EMP, V.CD_FND_VERBA, R.CD_FND_VERBA_RECB, V.CD_FORN, R.DT_RECEB)
                                                          ), 0) AS SLD_RECB
                     , 2 ORDEM
                     , CD_USU_NEGOCIADOR
                     , '' NM_USU
                     , 0
                     , DS_FND_VERBA_TIPO
                     , 0 PARC
                     , 0 VLR_DP
                     , 0 NR_DP
                     , 0 CD_FILIAL
                FROM
                     CG_FND_VERBA V
                     INNER JOIN CG_FND_VERBA_RECB R
                     ON V.CD_EMP = R.CD_EMP
                        AND V.CD_FND_VERBA = R.CD_FND_VERBA
                     INNER JOIN CG_FND_VERBA_TIPO A
                     ON V.CD_FND_VERBA_TIPO = A.CD_FND_VERBA_TIPO
                WHERE V.CD_EMP = @CD_EMP
                      AND R.STATUS = 0
                      AND R.DT_RECEB BETWEEN @DT_INI AND @DT_FIM;
          INSERT INTO @RS_RETORNO (TP_LANC, CD_FND_VERBA, DT_LANCTO
							 , DT_VENCTO, CD_FORN, NM_FANT, VERBA
							 , HIST, NEGOCIADO, CREDITO, DEBITO, SLD_USO, SLD_RECB
							 , ORDEM, CD_NEGOCIADOR, NM_NEGOCIADOR, QTDE_DIAS_VENCIDO, DS_FND_VERBA_TIPO
							 , PARC, VLR_DP, NR_DUP, CD_FILIAL)
                SELECT 0 TP_LANC
                     , V.CD_FND_VERBA
                     , S.DT_SAQUE
				 , V.DT_VENCTO
                     , CD_FORN
                     , '' NM_FANT
                     , V.HIST_LANC VERBA 
                     , S.HIST_SAQ HIST
                     , 0 AS NEGOCIADO
                     , 0 AS CREDITO
                     , S.VLR_SAQUE AS DEBITO
                     , (VLR_LANC - VLR_GLOSA) - ISNULL(
                                                      (
                                                          SELECT SLD_USO
                                                          FROM UFD_CG_RETORNA_SALDO_USO_FORN(@CD_EMP, V.CD_FND_VERBA, V.CD_FORN, S.DT_SAQUE)
                                                      ), 0) AS SLD_USO
                     , (VLR_LANC - VLR_GLOSA) - ISNULL(
                                                      (
                                                          SELECT SLD_RECB
                                                          FROM UFD_CG_RETORNA_SALDO_RECEB_FORN(@CD_EMP, V.CD_FND_VERBA, 0, V.CD_FORN, S.DT_SAQUE)
                                                      ), 0) AS SLD_RECB
                     , 3 ORDEM
                     , CD_USU_NEGOCIADOR
                     , '' NM_USU
                     , 0
                     , DS_FND_VERBA_TIPO
                     , 0 PARC
                     , 0 VLR_DP
                     , 0 NR_DP
                     , 0 CD_FILIAL
                FROM
                     CG_FND_VERBA V
                     INNER JOIN CG_FND_VERBA_SAQUE S
                     ON V.CD_EMP = S.CD_EMP
                        AND V.CD_FND_VERBA = S.CD_FND_VERBA
                     INNER JOIN CG_FND_VERBA_TIPO A
                     ON V.CD_FND_VERBA_TIPO = A.CD_FND_VERBA_TIPO
                WHERE V.CD_EMP = @CD_EMP
                      AND S.STATUS = 0
                      AND S.DT_SAQUE BETWEEN @DT_INI AND @DT_FIM;
         INSERT INTO @RS_RETORNO (TP_LANC, CD_FND_VERBA, DT_LANCTO
							 , DT_VENCTO, CD_FORN, NM_FANT, VERBA
							 , HIST, NEGOCIADO, CREDITO, DEBITO, SLD_USO, SLD_RECB
							 , ORDEM, CD_NEGOCIADOR, NM_NEGOCIADOR, QTDE_DIAS_VENCIDO, DS_FND_VERBA_TIPO
							 , PARC, VLR_DP, NR_DUP, CD_FILIAL)
                SELECT 0 TP_LANC
                     , V.CD_FND_VERBA
                     , P.DT_CAD
				 , V.DT_VENCTO
                     , V.CD_FORN
                     , '' NM_FANT
                     , V.HIST_LANC VERBA
                     , 'ALOCACAO DE VERBA PROD. REF.: '+CONVERT( CHAR, CD_PROD) HIST
                     , 0 AS NEGOCIADO
                     , 0 AS CREDITO
                     , P.VLR_VERBA_TOT AS DEBITO
                     , (VLR_LANC - VLR_GLOSA) - ISNULL(
                                                      (
                                                          SELECT SLD_USO
                                                          FROM UFD_CG_RETORNA_SALDO_USO_FORN(@CD_EMP, V.CD_FND_VERBA, V.CD_FORN, P.DT_CAD)
                                                      ), 0) AS SLD_USO
                     , (VLR_LANC - VLR_GLOSA) - ISNULL(
                                                      (
                                                          SELECT SLD_RECB
                                                          FROM UFD_CG_RETORNA_SALDO_RECEB_FORN(@CD_EMP, V.CD_FND_VERBA, 0, V.CD_FORN, P.DT_CAD)
                                                      ), 0) AS SLD_RECB
                     , 4 ORDEM
                     , CD_USU_NEGOCIADOR
                     , '' NM_USU
                     , 0
                     , DS_FND_VERBA_TIPO
                     , 0 PARC
                     , 0 VLR_DP
                     , 0 NR_DP
                     , 0 CD_FILIAL
                FROM
                     CG_FND_VERBA V
                     INNER JOIN CG_FND_VERBA_PROD P
                     ON V.CD_EMP = P.CD_EMP
                        AND V.CD_FND_VERBA = P.CD_FND_VERBA
                     INNER JOIN CG_FND_VERBA_TIPO A
                     ON V.CD_FND_VERBA_TIPO = A.CD_FND_VERBA_TIPO
                WHERE V.CD_EMP = @CD_EMP
                      AND P.DT_CAD BETWEEN @DT_INI AND @DT_FIM
                      AND P.VLR_VERBA_TOT > 0;
       INSERT INTO @RS_RETORNO (TP_LANC, CD_FND_VERBA, DT_LANCTO
							 , DT_VENCTO, CD_FORN, NM_FANT, VERBA
							 , HIST, NEGOCIADO, CREDITO, DEBITO, SLD_USO, SLD_RECB
							 , ORDEM, CD_NEGOCIADOR, NM_NEGOCIADOR, QTDE_DIAS_VENCIDO, DS_FND_VERBA_TIPO
							 , PARC, VLR_DP, NR_DUP, CD_FILIAL)
                SELECT 3 TP_LANC
                     , V.CD_FND_VERBA
                     , V.DT_LANCTO
				 , V.DT_VENCTO
                     , V.CD_FORN
                     , '' NM_FORN
                     , V.HIST_LANC VERBA
                     , ' LANCAMENTO DE VERBA' HIST
                     , (V.VLR_LANC - ISNULL(V.VLR_GLOSA, 0)) AS NEGOCIADO
                     , 0 AS CREDITO
                     , 0 AS DEBITO
                     , (V.VLR_LANC - V.VLR_GLOSA) SLD_USO
                     , (V.VLR_LANC - V.VLR_GLOSA) AS SLD_RECB
                     , 1 ORDEM
                     , V.CD_USU_NEGOCIADOR NEGOCIADOR
                     , '' NM_NEGOCIADOR
                     , 0 AS QTDE_DIAS_ATRASO
                     , A.DS_FND_VERBA_TIPO
                     , isnull(D.PARC, 0)
                     , isnull(D.VLR_DP, 0)
                     , isnull(D.NR_DP, 0)
                     , isnull(D.CD_FILIAL, 0)
                FROM
                     CG_FND_VERBA V
                     INNER JOIN CG_FND_VERBA_TIPO A
                     ON V.CD_FND_VERBA_TIPO = A.CD_FND_VERBA_TIPO
                     LEFT JOIN
                (
                    SELECT D.CD_EMP
                         , D.CD_FILIAL
                         , D.NR_DP
                         , D.ANO
                         , D.PARC
                         , D.VLR_DP
                         , CRD.CD_FND_VERBA
                    FROM
                         CG_FND_VERBA_RC_DEB_DUP_NR_CTR CRD
                         LEFT JOIN RC_DEB D
                         ON CRD.CD_EMP = D.CD_EMP
                            AND CRD.CD_FILIAL = D.CD_FILIAL
                            AND CRD.NR_DP = D.NR_DP
                            AND CRD.ANO = D.ANO
                            AND D.STS_DP <> 3
                    WHERE CRD.CD_EMP = @CD_EMP
                ) d
                     ON V.CD_FILIAL_FAT = d.CD_FILIAL
                        AND V.CD_FND_VERBA = d.CD_FND_VERBA
                     JOIN
                (
                    SELECT DISTINCT
                           CD_FND_VERBA
                    FROM @RS_RETORNO
                    UNION
                    SELECT cd_fnd_verba
                    FROM CG_FND_VERBA
                    WHERE DT_LANCTO BETWEEN @DT_INI AND @DT_FIM
                          AND cd_emp = @cd_emp
                ) R
                     ON V.CD_FND_VERBA = R.CD_FND_VERBA
                WHERE V.CD_EMP = @CD_EMP;
         UPDATE R
           SET
               NM_NEGOCIADOR = U.NM_USU,
               NM_FANT = PG_FORN.NM_FANT
         FROM @RS_RETORNO R
              JOIN glb_usu u
              ON r.CD_NEGOCIADOR = U.CD_USU
              INNER JOIN PG_FORN
              ON @CD_EMP = PG_FORN.CD_EMP
                 AND R.CD_FORN = PG_FORN.CD_FORN;
         RETURN;
     END;